(function () {
  const style = document.createElement('style');
  style.innerHTML = `
    #cookieConsentBanner {
      position: fixed;
      bottom: 0;
      left: 0;
      right: 0;
      background:rgb(255, 255, 254);
      border-top: 2px solid #ccc;
      padding: 16px;
      font-family: sans-serif;
      z-index: 100000;
      box-shadow: 0 -2px 10px rgba(255, 255, 255, 0.2);
      display: flex;
      justify-content: space-between;
      align-items: center;
    }
    #cookieConsentBanner div {
      display: flex;
      gap: 12px;
      align-items: center;
    }
    .tracking-log {
      position: absolute;
      background: rgba(0, 0, 0, 0.85);
      color: white;
      padding: 10px 16px;
      font-size: 16px;
      border-radius: 8px;
      pointer-events: none;
      z-index: 99999;
      max-width: 400px;
      line-height: 1.5;
    }
    .plugin-image-left,
    .plugin-image-right {
      position: fixed;
      top: 20%;
      z-index: 100001;
      pointer-events: none;
    }
    .plugin-image-left {
      left: 10px;
      transform: scale(0.2);
      transform-origin: top left;
    }
    .plugin-image-right {
      right: 10px;
      transform: scale(0.3);
      transform-origin: top right;
    }
  `;
  document.head.appendChild(style);

  const leftImg = document.createElement('img');
  leftImg.className = 'plugin-image-left';
  leftImg.src = chrome.runtime.getURL('image/left.png');
  leftImg.style.objectFit = 'contain';
  document.body.appendChild(leftImg);

  const rightImg = document.createElement('img');
  rightImg.className = 'plugin-image-right';
  rightImg.src = chrome.runtime.getURL('image/right.png');
  rightImg.style.objectFit = 'contain';
  document.body.appendChild(rightImg);

  const banner = document.createElement('div');
  banner.id = 'cookieConsentBanner';
  banner.innerHTML = `
    <span>🍪 This website uses Cookies to track your behavior. Clicking "Accept" means you agree to our default tracking mechanism. / 本网站使用 Cookie 来跟踪您的行为。点击"接受"即表示同意我们的默认记录机制。</span>
    <div>
      <button id="acceptCookie">Accept / 接受</button>
      <button onclick="this.parentNode.parentNode.remove()">Reject / 拒绝</button>
    </div>
  `;
  document.body.appendChild(banner);

  document.getElementById('acceptCookie').onclick = () => {
    banner.remove();
    startTracking();
  };

  function startTracking() {
    const persistentLogs = new Map();

    const updatePersistentLog = (key, text, x, y, options = {}) => {
      const { fixed = false, offset = true } = options;
      let log = persistentLogs.get(key);

      if (!log) {
        log = document.createElement('div');
        log.className = 'tracking-log';
        persistentLogs.set(key, log);
        document.body.appendChild(log);
      }

      const offsetValue = offset ? 10 : 0;
      log.style.position = fixed ? 'fixed' : 'absolute';
      log.style.left = `${x + offsetValue}px`;
      log.style.top = `${y + offsetValue}px`;
      log.innerText = text;

      return log;
    };

    let mousePauseTimer = null;
    let lastMousePosition = null;
    let stationarySeconds = 0;
    let stationaryTimerId = null;
    const mousePauseDelay = 300;

    const updatePageStayLog = () => {
      updatePersistentLog('pageStay', `Page Stay ${stationarySeconds}s / 页面停留 ${stationarySeconds} 秒`, 20, window.innerHeight - 120, {
        fixed: true,
        offset: false,
      });
    };

    const startStationaryTimer = () => {
      if (stationaryTimerId) {
        clearInterval(stationaryTimerId);
      }
      stationaryTimerId = setInterval(() => {
        stationarySeconds += 1;
        updatePageStayLog();
      }, 1000);
    };

    const resetStationaryTimer = () => {
      stationarySeconds = 0;
      updatePageStayLog();
      startStationaryTimer();
    };

    resetStationaryTimer();

    document.body.addEventListener('mousemove', (e) => {
      resetStationaryTimer();

      lastMousePosition = {
        x: e.pageX,
        y: e.pageY,
        clientX: e.clientX,
        clientY: e.clientY,
        screenX: e.screenX,
        screenY: e.screenY,
      };

      if (mousePauseTimer) {
        clearTimeout(mousePauseTimer);
      }

      mousePauseTimer = setTimeout(() => {
        if (!lastMousePosition) return;
        const hoveredElement = document.elementFromPoint(lastMousePosition.clientX, lastMousePosition.clientY);
        const hoveredLink = hoveredElement && hoveredElement.closest('a');
        const hoveredImage = hoveredElement && hoveredElement.closest('img');

        if (hoveredLink) {
          const linkText =
            hoveredLink.getAttribute('data-ad-name') ||
            hoveredLink.innerText.trim() ||
            hoveredLink.title ||
            hoveredLink.getAttribute('aria-label') ||
            hoveredLink.getAttribute('alt') ||
            hoveredLink.href;
          const isAd = /广告|ad/i.test(linkText || '');
          const label = linkText ? `"${linkText}"` : '';
          showLog(
            `${isAd ? 'Mouse Hovering on Ad / 鼠标停在广告' : 'Mouse Hovering on Link / 鼠标停在链接'} ${label}`,
            lastMousePosition.x,
            lastMousePosition.y
          );
          return;
        }

        if (hoveredImage) {
          const imageName =
            hoveredImage.alt ||
            hoveredImage.getAttribute('data-name') ||
            hoveredImage.getAttribute('aria-label') ||
            hoveredImage.title ||
            'Image / 图片';
          showLog(`Mouse Hovering on Image / 鼠标停在图片 "${imageName}"`, lastMousePosition.x, lastMousePosition.y);
          return;
        }

        showLog(`Mouse Hovering at / 鼠标停在 (${lastMousePosition.clientX}, ${lastMousePosition.clientY})`, lastMousePosition.x, lastMousePosition.y);
      }, mousePauseDelay);
    });

    document.body.addEventListener('click', (e) => {
      const clickedLink = e.target.closest && e.target.closest('a');
      const clickedImage = e.target.closest && e.target.closest('img');

      if (clickedLink) {
        const linkText =
          clickedLink.getAttribute('data-ad-name') ||
          clickedLink.innerText.trim() ||
          clickedLink.title ||
          clickedLink.getAttribute('aria-label') ||
          clickedLink.getAttribute('alt') ||
          clickedLink.href;
        const isAd = /广告|ad/i.test(linkText || '');
        const label = linkText ? `"${linkText}"` : '';
        showLog(
          `${isAd ? 'Clicked Ad / 点击了广告' : 'Clicked Link / 点击了链接'} ${label}`,
          e.pageX,
          e.pageY
        );
        return;
      }

      if (clickedImage) {
        const imageName =
          clickedImage.alt ||
          clickedImage.getAttribute('data-name') ||
          clickedImage.getAttribute('aria-label') ||
          clickedImage.title ||
          'Image / 图片';
        showLog(`Clicked Image / 点击了图片 "${imageName}"`, e.pageX, e.pageY);
        return;
      }

      showLog(`Clicked / 点击了 <${e.target.tagName}>`, e.pageX, e.pageY);
    });

    document.addEventListener('scroll', () => {
      updatePersistentLog(
        'scrollPosition',
        `Scrolled to / 滚动到 ${window.scrollY}px`,
        window.innerWidth - 260,
        window.innerHeight - 140,
        { fixed: true, offset: false }
      );
    });
  }

  function showLog(text, x, y, options = {}) {
    const { fixed = false, offset = true } = options;
    const log = document.createElement('div');
    log.className = 'tracking-log';
    log.style.position = fixed ? 'fixed' : 'absolute';

    const offsetValue = offset ? 10 : 0;
    log.style.left = `${x + offsetValue}px`;
    log.style.top = `${y + offsetValue}px`;
    log.innerText = text;
    document.body.appendChild(log);
  }
})();